import pandas as pd  
from sklearn.cluster import KMeans 
from sklearn.metrics import silhouette_score 
import matplotlib.pyplot as plt
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  
  
silhouette_scores = [] 
for cluster_num in range(2, 15):  # Starting from 2 because silhouette score is not defined for 1 cluster 
    kmeans = KMeans(n_clusters=cluster_num, random_state=42) 
    cluster_labels = kmeans.fit_predict(data_for_clustering_scaled) 
    silhouette_avg = silhouette_score(data_for_clustering_scaled, cluster_labels) 
    silhouette_scores.append(silhouette_avg) 

# Plot silhouette scores 
plt.figure(figsize=(10, 6)) 
plt.plot(range(2, 15), silhouette_scores, marker='o', linestyle='--') 
plt.title('Silhouette Scores for Different Number of Clusters') 
plt.xlabel('Number of Clusters') 
plt.ylabel('Silhouette Score') 
plt.grid(True) 
plt.savefig('ref_result/Silhouette_Scores.png') 
plt.show() 